

//transforms

float4x4	shader_transform_world;
float4x4	shader_transform_view;
float4x4	shader_transform_proj;
float4x4	shader_transform_worldView;
float4x4	shader_transform_viewProj;
float4x4	shader_transform_worldViewProj;

//lights

float4		shader_light_position;
float4		shader_light_direction;
float4		shader_light_diffuse;
float4		shader_light_ambient;
float4		shader_light_specular;
float4x4	shader_light_view;
float4x4	shader_light_viewProj;

//camera

float4 		shader_camera_eyePosition;
float4 		shader_camera_eyeVector;
float4 		shader_camera_upVector;

//textures

TEXTURE		shader_texture_0;
TEXTURE		shader_texture_1;
TEXTURE		shader_texture_2;
TEXTURE		shader_texture_3;
TEXTURE		shader_texture_4;
TEXTURE		shader_texture_5;
TEXTURE		shader_texture_cubemap;
TEXTURE		shader_texture_shadowmap;

//geometry

float4		shader_geometry_colour;

float		LOD_firstLevel;
float		LOD_nextLevel;
float		LOD_changePoint;
float3		eyePosition;
float2		sectionPosition;
float2		chunkPosition;
float		chunkSize;
float		mapSize;

float		shader_misc_shadow_mapSize;
float		shader_misc_shadow_mapTexelSize;

#define		SHADOW_EPSILON 0.001f

float		g_light_farPlane;
float4x4	g_shadowerTransform;
float		LOD_midDetailDistance;
float		LOD_nearDetailDistance;

///////////////////////////////////////////////////////////

struct VS_INPUT 
{
	float2	position	:	TEXCOORD0;
	float2	uv			:	TEXCOORD1;
	float	height		:	TEXCOORD2;
	float	nextHeight	:	TEXCOORD3;
};
	
///////////////////////////////////////////////////////////

struct VS_OUTPUT 
{
	float4	position		:	POSITION;
	float2	uv				:	TEXCOORD0;
	float	detailMulti		:	TEXCOORD1;
	
	float4	posTex			:	TEXCOORD2;
	float	depth			:	TEXCOORD3;
};

///////////////////////////////////////////////////////////

VS_OUTPUT vs_terrain_near( VS_INPUT input )
{
	VS_OUTPUT output = (VS_OUTPUT) 0;
	
	output.position = float4(input.position.x + sectionPosition.x,input.height,input.position.y + sectionPosition.y,1);
	
	float nLodDistance = sqrt((eyePosition.x-output.position.x)*(eyePosition.x-output.position.x) + (eyePosition.y-output.position.y)*(eyePosition.y-output.position.y) + (eyePosition.z-output.position.z)*(eyePosition.z-output.position.z));
	if (nLodDistance >= LOD_changePoint)
		output.position.y = lerp( input.height, input.nextHeight, clamp((nLodDistance - LOD_changePoint) / ((LOD_nextLevel - LOD_firstLevel) * 0.25f),0,1) );

	output.posTex = mul( output.position, shader_light_viewProj );
	output.depth = saturate(output.posTex.z);
	
	output.position = mul(output.position, shader_transform_viewProj);
	
	output.uv = input.uv;
	output.detailMulti = 1.0f - pow(saturate(output.position.z / LOD_nearDetailDistance),3.0f);

	return output;
}

////////////////////////////////////////////////////////////

sampler sampler_colour_1 = sampler_state
{
	Texture = (shader_texture_0);
	AddressU=Clamp;
	AddressV=Clamp;
};

sampler sampler_colour_2 = sampler_state
{
	Texture = (shader_texture_1);
	AddressU=Clamp;
	AddressV=Clamp;
};

sampler sampler_colour_3 = sampler_state
{
	Texture = (shader_texture_2);
	MipFilter=Linear;
	AddressU=Wrap;
	AddressV=Wrap;
};

sampler sampler_colour_4 = sampler_state
{
	Texture = (shader_texture_3);
	MipFilter=Linear;
	AddressU=Clamp;
	AddressV=Clamp;
};

sampler sample_colour_shadow = sampler_state 
{ 
	Texture = (shader_texture_shadowmap); 
	AddressU = Clamp; 
	AddressV = Clamp; 
};

////////////////////////////////////////////////////////////

float4 ps_terrain_near( VS_OUTPUT input ) : COLOR0
{
	// calculate shadowing

	float2 projTexCoords;
	projTexCoords.x = input.posTex.x / 2.0f + 0.5f;
	projTexCoords.y = -input.posTex.y / 2.0f + 0.5f;
	
	float shadowTerm = ((tex2D( sample_colour_shadow, projTexCoords ).x <= input.depth - SHADOW_EPSILON ? shader_light_ambient.r : 1.0f)
					 + (tex2D( sample_colour_shadow, projTexCoords + float2( -shader_misc_shadow_mapTexelSize, 0.0f ) ).x <= input.depth - SHADOW_EPSILON ? shader_light_ambient.r : 1.0f)
					 + (tex2D( sample_colour_shadow, projTexCoords + float2( shader_misc_shadow_mapTexelSize, 0.0f ) ).x <= input.depth - SHADOW_EPSILON ? shader_light_ambient.r : 1.0f)
					 + (tex2D( sample_colour_shadow, projTexCoords + float2( 0.0f, -shader_misc_shadow_mapTexelSize ) ).x <= input.depth - SHADOW_EPSILON ? shader_light_ambient.r : 1.0f)
					 + (tex2D( sample_colour_shadow, projTexCoords + float2( 0.0f, shader_misc_shadow_mapTexelSize ) ).x <= input.depth - SHADOW_EPSILON ? shader_light_ambient.r : 1.0f)) / 5.0f;


	// calculate texturing

	float2 nUv = (chunkPosition + input.uv * chunkSize) * (1.0f / mapSize);
	float2 nUvC = nUv * 100.0f; //75.0f;

	
	// base colour

	float3 nBaseColour = tex2D(sampler_colour_4, input.uv );


	// second detail colour

	float nHighDetailColour = lerp(lerp(lerp(	tex2D(sampler_colour_3, nUvC).r,	
												tex2D(sampler_colour_3, nUvC).g, tex2D(sampler_colour_2, nUv).r ), 
												tex2D(sampler_colour_3, nUvC).b, tex2D(sampler_colour_2, nUv).g ), // + tex2D(sampler_colour_3, nUvC).g ),
												tex2D(sampler_colour_3, nUvC).a, tex2D(sampler_colour_2, nUv).b );

	
	float3 nDetailColour = saturate(nBaseColour + 0.0333f ) * nHighDetailColour * 1.25f;
	
	return float4(shadowTerm * lerp(nBaseColour, nDetailColour, input.detailMulti), 1);
}

////////////////////////////////////////////////////////////

technique terrain_near_11_20
{
	pass P0
	{
		AlphaBlendEnable = False;
		AlphaTestEnable = False;

		VertexShader = compile vs_1_1 vs_terrain_near();	
		PixelShader = compile ps_2_0 ps_terrain_near();	
	}
}

technique terrain_near_11_00
{
	pass P0
	{
	}
}